using UnityEngine;
using System.Collections;
using Verse.Sound;
using Verse;

namespace RimWorld{
public class Bullet : Projectile
{
	protected override void Impact(Thing hitThing)
	{
		var map = Map; // before Impact!

		base.Impact(hitThing);
		
		if( hitThing != null )
		{
			int dmgAmount = def.projectile.damageAmountBase;
			DamageInfo dinfo = new DamageInfo(def.projectile.damageDef, dmgAmount, angle: ExactRotation.eulerAngles.y, instigator: launcher, weaponGear: equipmentDef);
			hitThing.TakeDamage(dinfo);
		}
		else
		{
			SoundDefOf.BulletImpactGround.PlayOneShot(new TargetInfo(Position, map));
			MoteMaker.MakeStaticMote(ExactPosition, map, ThingDefOf.Mote_ShotHit_Dirt);
		}
	}
}

/*
public class BulletIncendiary : Bullet
{
protected override void Impact(Thing hitThing)
{
	base.Impact(hitThing);

	if( hitThing != null )
		hitThing.TryAttachFire(0.2f);
	else
	{
		GenSpawn.Spawn( ThingDefOf.Puddle_Fuel, Position);

		FireUtility.TryStartFireIn(Position, 0.2f);
	}

	MoteThrower.ThrowStatic(Position, ThingDefOf.Mote_ShotFlash, 6f );
	MoteThrower.ThrowMicroSparks(Position.ToVector3Shifted());
}
}*/
}